package gravity_edit;

import javax.microedition.lcdui.*;

class MyCanvas extends Canvas implements CommandListener
{
	static final int kLEFT = 0;
	static final int kRIGHT = 1;
	static final int kUP = 2;
	static final int kDOWN = 3;
	static final int kNUM1 = 4;
	static final int kNUM2 = 5;
	static final int kNUM3 = 6;
	static final int kNUM4 = 7;
	static final int kNUM5 = 8;
	static final int kNUM6 = 9;
	static final int kNUM7 = 10;
	static final int kNUM8 = 11;
	static final int kNUM9 = 12;
	static final int kNUM0 = 13;
	static final int kSTAR = 14;
	static final int kSHARP = 15;

	static final int INFINITY = Integer.MAX_VALUE;

	public static final int FILE_RMS = 0;
	public static final int FILE_SIEMENS = 1;
	public static final int FILE_JSR75 = 2;
	public static final int FILE_SYMBIAN = 3;

	int iCurVertex = -1;

	String sStatus = "Ready";
	int iStatusTimeout = INFINITY;

	// Options
	Form formOptions = null;
	ChoiceGroup cgOptView = new ChoiceGroup ("View", Choice.MULTIPLE);
	TextField tfRootJsr75 = new TextField ("Jsr75 root", "c:\\", 8, TextField.ANY);
	TextField tfRootSiemens = new TextField ("Siemens root", "0:\\", 8, TextField.ANY);
	TextField tfRootSymbian = new TextField ("Symbian root", "e:\\", 8, TextField.ANY);
	TextField tfSpeed = new TextField ("Cursor speed", "100", 3, TextField.NUMERIC);

	int nSpeed = 100;

	// Manage

	int curLevel = 0;
	int curTrack = 0;

	List lsLevel = null;
	List lsEasy = null;
	List lsMedium = null;
	List lsPro = null;

	boolean bDrawVertexCoords = false;
	public int nFileAccess = FILE_RMS;

	boolean[] keys = new boolean[16];

	Command cmdOptions = new Command ("Options", Command.SCREEN, 1);
	Command cmdManage = new Command ("Manage Levels", Command.SCREEN, 1);
	Command cmdExit = new Command ("Exit", Command.SCREEN, 1);

	Command cmdSave = new Command ("Save", Command.SCREEN, 1);
	Command cmdLoad = new Command ("Load", Command.SCREEN, 1);

	Command cmdRun = new Command ("Run game", Command.SCREEN, 1);
	
	TextField tfFileNameSave = new TextField ("File", "levels.mrg", 32, TextField.ANY);
	TextField tfFileNameLoad = new TextField ("File", "levels.mrg", 32, TextField.ANY);
	Form formSave = new Form ("Save");
	Form formLoad = new Form ("Load");
	ChoiceGroup cgFileModeSave = new ChoiceGroup ("File mode", Choice.POPUP);
	ChoiceGroup cgFileModeLoad = new ChoiceGroup ("File mode", Choice.POPUP);

	Command cmdOk = new Command ("OK", Command.OK, 1);

	Command cmdBack = new Command ("Back", Command.BACK, 1);

	Command cmdCopy = new Command ("Copy", Command.SCREEN, 1);
	Command cmdPaste = new Command ("Paste", Command.SCREEN, 1);
	Command cmdMoveUp = new Command ("Move up", Command.SCREEN, 1);
	Command cmdMoveDown = new Command ("Move down", Command.SCREEN, 1);
	Command cmdCreateNew = new Command ("Create new", Command.SCREEN, 1);
	Command cmdRemove = new Command ("Remove", Command.SCREEN, 1);

	Command cmdLevelProp = new Command ("Level properties", Command.SCREEN, 1);

	Main mMain;
	CustomFont font;

	Form formLevelProp = new Form ("Level properties");
	TextField propName = new TextField ("Name", "", 12, TextField.ANY);

	int iCopyLeague = -1;
	int iCopyTrack = -1;

	int w = 176, h = 208;

	int camX = 0, camY = 0;

	MyCanvas(Main p_mMain)
	{
		setFullScreenMode (true);

		mMain = p_mMain;
		for (int i = 0; i < 16; i++)
			keys[i] = false;

		font = new CustomFont ("7pt-proportional");
		font.setColor (0x000000);

		formOptions = new Form ("Options");
		formOptions.addCommand (cmdOk);
		formOptions.setCommandListener (this);
		
		cgOptView.append ("Vertex coord.", null);
		
		formOptions.append (tfSpeed);
		formOptions.append (cgOptView);
		formOptions.append (tfRootJsr75);
		formOptions.append (tfRootSiemens);
		formOptions.append (tfRootSymbian);

		cgFileModeSave.append ("Rms", null);
		cgFileModeSave.append ("Siemens", null);
		cgFileModeSave.append ("Jsr-75", null);
		cgFileModeSave.append ("Symbian", null);

		cgFileModeLoad.append ("Rms", null);
		cgFileModeLoad.append ("Siemens", null);
		cgFileModeLoad.append ("Jsr-75", null);
		cgFileModeLoad.append ("Symbian", null);

		formSave.append (cgFileModeSave);
		formSave.append (tfFileNameSave);
		formLoad.append (cgFileModeLoad);
		formLoad.append (tfFileNameLoad);
		
		formSave.addCommand (cmdOk);
		formSave.addCommand (cmdBack);
		formLoad.addCommand (cmdOk);
		formLoad.addCommand (cmdBack);

		formSave.setCommandListener (this);
		formLoad.setCommandListener (this);

		String[] stringArray = { "Easy", "Medium", "Pro" };
		lsLevel = new List("Level", Choice.IMPLICIT, stringArray, null);
		lsLevel.addCommand(cmdBack);
		lsLevel.setCommandListener(this);

		lsEasy = new List ("Easy", Choice.IMPLICIT);
		lsEasy.addCommand(cmdBack);
		lsEasy.addCommand(cmdMoveUp);
		lsEasy.addCommand(cmdMoveDown);
		lsEasy.addCommand(cmdCopy);
		lsEasy.addCommand(cmdPaste);
		lsEasy.addCommand(cmdCreateNew);
		lsEasy.addCommand(cmdRemove);
		lsEasy.setCommandListener(this);

		lsMedium = new List ("Medium", Choice.IMPLICIT);
		lsMedium.addCommand(cmdBack);
		lsMedium.addCommand(cmdMoveUp);
		lsMedium.addCommand(cmdMoveDown);
		lsMedium.addCommand(cmdCopy);
		lsMedium.addCommand(cmdPaste);
		lsMedium.addCommand(cmdCreateNew);
		lsMedium.addCommand(cmdRemove);
		lsMedium.setCommandListener(this);

		lsPro = new List ("Pro", Choice.IMPLICIT);
		lsPro.addCommand(cmdBack);
		lsPro.addCommand(cmdMoveUp);
		lsPro.addCommand(cmdMoveDown);
		lsPro.addCommand(cmdCopy);
		lsPro.addCommand(cmdPaste);
		lsPro.addCommand(cmdCreateNew);
		lsPro.addCommand(cmdRemove);
		lsPro.setCommandListener(this);

		UpdateList ();

		addCommand (cmdLevelProp);
		addCommand (cmdManage);
		addCommand (cmdSave);
		addCommand (cmdLoad);
		addCommand (cmdOptions);
		addCommand (cmdRun);
		addCommand (cmdExit);
		setCommandListener (this);

		formLevelProp.append (propName);
		
		formLevelProp.addCommand (cmdOk);
		formLevelProp.addCommand (cmdBack);
		formLevelProp.setCommandListener (this);

		bCanLeft = true;
		bCanRight = true;
		bCanUp = true;
		bCanDown = true;
	}

	void UpdateList ()
	{
		lsEasy.deleteAll ();
		lsMedium.deleteAll ();
		lsPro.deleteAll ();

		League league = mMain.levels.leagues[0];
		for (int i = 0; i < league.Count(); i++)
		{
			lsEasy.append (league.GetLevel(i).Name, null);
		}

		league = mMain.levels.leagues[1];
		for (int i = 0; i < league.Count(); i++)
		{
			lsMedium.append (league.GetLevel(i).Name, null);
		}

		league = mMain.levels.leagues[2];
		for (int i = 0; i < league.Count(); i++)
		{
			lsPro.append (league.GetLevel(i).Name, null);
		}

		if (curLevel == 0)
		{
			if (curTrack > mMain.levels.leagues[0].Count() - 1)
			{
				curTrack = mMain.levels.leagues[0].Count() - 1;
			}
		}
		if (curLevel == 1)
		{
			if (curTrack > mMain.levels.leagues[1].Count() - 1)
			{
				curTrack = mMain.levels.leagues[1].Count() - 1;
			}
		}
		if (curLevel == 2)
		{
			if (curTrack > mMain.levels.leagues[2].Count() - 1)
			{
				curTrack = mMain.levels.leagues[2].Count() - 1;
			}
		}
	}

	void SetStatus (String status, int timeout)
	{
		sStatus = status;
		iStatusTimeout = timeout;
	}
	public void keyPressed(int i)
	{
		switch (getGameAction(i))
		{
			case Canvas.LEFT:
				keys[kLEFT] = true;
				break;

			case Canvas.RIGHT:
				keys[kRIGHT] = true;
				break;

			case Canvas.UP:
				keys[kUP] = true;
				break;

			case Canvas.DOWN:
				keys[kDOWN] = true;
				break;

			default:
				break;
		}

		switch (i)
		{
			case Canvas.KEY_NUM1:
				keys[kNUM1] = true;
				break;

			case Canvas.KEY_NUM7:
				keys[kNUM7] = true;
				break;

			case Canvas.KEY_STAR:
				if (iCurVertex > 0 && iCurVertex < mMain.levels.leagues[curLevel].GetLevel(curTrack).Count() - 1)
				{
					mMain.levels.leagues[curLevel].GetLevel(curTrack).RemovePoint (iCurVertex);
					SetStatus ("del [" + iCurVertex + "]", 1000);
					iCurVertex = -1;
				}
				else if (iCurVertex == 0)
				{
					SetStatus ("Can't delete 1st point", 1000);
				}
				else if (iCurVertex == mMain.levels.leagues[curLevel].GetLevel(curTrack).Count() - 1)
				{
					SetStatus ("Can't delete last point", 1000);
				}
				break;

			case Canvas.KEY_POUND:
				Point2 newPt = new Point2 ();
				Level level = mMain.levels.leagues[curLevel].GetLevel (curTrack);
				int iPtBefore = 0;
				for (int j = 0; j < level.Count(); j++)
				{
					if (level.GetPoint (j).x < camX)
						iPtBefore = j;
				}
				newPt.x = camX;
				newPt.y = camY - 110;
				level.InsertPoint (iPtBefore + 1, newPt);

				SetStatus ("add (" + newPt.x + "," + newPt.y + ")", 1000);
				break;

			default:
				break;
		}
	}

	public void keyRepeated(int i)
	{
	}

	public void keyReleased(int i)
	{
		switch (getGameAction(i))
		{
			case Canvas.LEFT:
				keys[kLEFT] = false;
				break;

			case Canvas.RIGHT:
				keys[kRIGHT] = false;
				break;

			case Canvas.UP:
				keys[kUP] = false;
				break;

			case Canvas.DOWN:
				keys[kDOWN] = false;
				break;

			default:
				break;
		}

		switch (i)
		{
			case Canvas.KEY_NUM1:
				keys[kNUM1] = false;
				break;

			case Canvas.KEY_NUM7:
				bCanLeft = true;
				bCanRight = true;
				bCanUp = true;
				bCanDown = true;
				keys[kNUM7] = false;
				break;

			default:
				break;
		}
	}

	public void commandAction (Command c, Displayable d)
	{
		if (c == cmdManage)
		{
			mMain.display.setCurrent (lsLevel);
		}
		else if (c == List.SELECT_COMMAND)
		{
			if (d == lsLevel)
			{
				int iSel = lsLevel.getSelectedIndex ();
				if (iSel == 0)
					mMain.display.setCurrent (lsEasy);
				else if (iSel == 1)
					mMain.display.setCurrent (lsMedium);
				else if (iSel == 2)
					mMain.display.setCurrent (lsPro);
			}
			else if (d == lsEasy || d == lsMedium || d == lsPro)
			{
				int iSel = ((List)d).getSelectedIndex ();
				if (iSel >= 0)
				{
					if (d == lsEasy)
					{
						curLevel = 0;
						curTrack = iSel;
					}
					else if (d == lsMedium)
					{
						curLevel = 1;
						curTrack = iSel;
					}
					else if (d == lsPro)
					{
						curLevel = 2;
						curTrack = iSel;
					}
					camX = 0;
					camY = 0;
				}
				mMain.display.setCurrent (this);
			}
		}
		else if (c == cmdCopy)
		{
			iCopyTrack = ((List)d).getSelectedIndex ();
			if (d == lsEasy)
			{
				iCopyLeague = 0;
			}
			else if (d == lsMedium)
			{
				iCopyLeague = 1;
			}
			else if (d == lsPro)
			{	
				iCopyLeague = 2;
			}
		}
		else if (c == cmdPaste)
		{
			int iAfter = ((List)d).getSelectedIndex () + 1;
			Levels levels = mMain.levels;
			Level level = levels.leagues[iCopyLeague].GetLevel(iCopyTrack);
			Level newLevel = new Level (level);
			if (d == lsEasy)
			{
				levels.leagues[0].InsertLevel (iAfter, newLevel);
			}
			else if (d == lsMedium)
			{
				levels.leagues[1].InsertLevel (iAfter, newLevel);
			}
			else if (d == lsPro)
			{	
				levels.leagues[2].InsertLevel (iAfter, newLevel);
			}
			UpdateList ();
		}
		else if (c == cmdMoveUp)
		{
			int iTrack = ((List)d).getSelectedIndex ();

			Levels levels = mMain.levels;

			if (iTrack > 0)
			{
				if (d == lsEasy)
				{
					levels.leagues[0].Swap (iTrack, iTrack - 1);
				}
				else if (d == lsMedium)
				{
					levels.leagues[1].Swap (iTrack, iTrack - 1);
				}
				else if (d == lsPro)
				{	
					levels.leagues[2].Swap (iTrack, iTrack - 1);
				}

				UpdateList ();
				((List)d).setSelectedIndex (iTrack-1, true);

				curTrack--;
			}
		}
		else if (c == cmdMoveDown)
		{
			int iTrack = ((List)d).getSelectedIndex ();

			Levels levels = mMain.levels;

			if (iTrack < ((List)d).size() - 1)
			{
				if (d == lsEasy)
				{
					levels.leagues[0].Swap (iTrack, iTrack + 1);
				}
				else if (d == lsMedium)
				{
					levels.leagues[1].Swap (iTrack, iTrack + 1);
				}
				else if (d == lsPro)
				{	
					levels.leagues[2].Swap (iTrack, iTrack + 1);
				}

				UpdateList ();
				((List)d).setSelectedIndex (iTrack + 1, true);
				curTrack++;
			}
		}
		else if (c == cmdBack && d == lsLevel)
		{
			mMain.display.setCurrent (this);
		}
		else if (c == cmdBack && (d == lsEasy || d == lsMedium || d == lsPro))
		{
			mMain.display.setCurrent (lsLevel);
		}
		else if (c == cmdBack && d == formLevelProp)
		{
			mMain.display.setCurrent (this);
		}
		else if (c == cmdOptions)
		{
			tfRootJsr75.setString (mMain.fs.rootJsr75);
			tfRootSiemens.setString (mMain.fs.rootSiemens);
			tfRootSymbian.setString (mMain.fs.rootSymbian);

			mMain.display.setCurrent (formOptions);
		}
		else if (c == cmdLevelProp)
		{
			propName.setString (mMain.levels.leagues[curLevel].GetLevel(curTrack).Name);
			mMain.display.setCurrent (formLevelProp);
		}
		else if (c == cmdExit)
		{
			mMain.destroyApp (false);
		}
		else if (c == cmdOk && d == formOptions)
		{
			boolean[] bChecked = new boolean[1];
			cgOptView.getSelectedFlags (bChecked);
			bDrawVertexCoords = bChecked[0];

			mMain.fs.rootJsr75 = tfRootJsr75.getString ();
			mMain.fs.rootSiemens = tfRootSiemens.getString ();
			mMain.fs.rootSymbian = tfRootSymbian.getString ();

			nSpeed = Integer.parseInt (tfSpeed.getString(), 10);
			if (nSpeed < 10)
				nSpeed = 10;
			if (nSpeed > 200)
				nSpeed = 200;

			mMain.display.setCurrent (this);
		}
		else if (c == cmdOk && d == formLevelProp)
		{
			mMain.levels.leagues[curLevel].GetLevel(curTrack).Name = propName.getString ();
			
			UpdateList ();

			propName.setString ("");
			mMain.display.setCurrent (this);
		}
		else if (c == cmdSave)
		{
			mMain.display.setCurrent (formSave);
		}
		else if (c == cmdLoad)
		{
			mMain.display.setCurrent (formLoad);
		}
		else if (c == cmdOk && d == formSave)
		{
			boolean[] bFileMode = new boolean[4];
			cgFileModeSave.getSelectedFlags (bFileMode);
			if (bFileMode[0])
				nFileAccess = FILE_RMS;
			else if (bFileMode[1])
				nFileAccess = FILE_SIEMENS;
			else if (bFileMode[2])
				nFileAccess = FILE_JSR75;
			else if (bFileMode[3])
				nFileAccess = FILE_SYMBIAN;

			new Thread()
			{
				public void run() 
				{
					String sFile = tfFileNameSave.getString ();

					boolean bRes = false;

					if (nFileAccess == FILE_RMS)
					{
						bRes = mMain.fs.WriteRms (sFile, mMain.levels.Save ());
					}
					else if (nFileAccess == FILE_SIEMENS)
					{
						bRes = mMain.fs.WriteSiemens (sFile, mMain.levels.Save ());
					}
					else if (nFileAccess == FILE_JSR75)
					{
						bRes = mMain.fs.WriteJsr75 (sFile, mMain.levels.Save ());
					}
					else if (nFileAccess == FILE_SYMBIAN)
					{
						bRes = mMain.fs.WriteSymbian (sFile, mMain.levels.Save ());
					}
					if (bRes)
						SetStatus ("Saved", 1000);
					else
						SetStatus ("Save failed", 1000);
					ResetTiming ();
					mMain.display.setCurrent (mMain.mCanvas);
				}
			}.start ();
		}
		else if (c == cmdOk && d == formLoad)
		{
			boolean[] bFileMode = new boolean[4];
			cgFileModeLoad.getSelectedFlags (bFileMode);
			if (bFileMode[0])
				nFileAccess = FILE_RMS;
			else if (bFileMode[1])
				nFileAccess = FILE_SIEMENS;
			else if (bFileMode[2])
				nFileAccess = FILE_JSR75;
			else if (bFileMode[3])
				nFileAccess = FILE_SYMBIAN;

			new Thread()
			{
				public void run() 
				{
					String sFile = tfFileNameLoad.getString ();

					byte[] data = null;

					if (nFileAccess == FILE_RMS)
					{
						data = mMain.fs.ReadRms (sFile);
					}
					else if (nFileAccess == FILE_SIEMENS)
					{
						data = mMain.fs.ReadSiemens (sFile);
					}
					else if (nFileAccess == FILE_JSR75)
					{
						data = mMain.fs.ReadJsr75 (sFile);
					}
					else if (nFileAccess == FILE_SYMBIAN)
					{
						data = mMain.fs.ReadSymbian (sFile);
					}

					if (data != null)
					{
						mMain.levels.Load (data);
						UpdateList ();
						ResetTiming ();
						SetStatus ("Loaded", 1000);
					}
					else
					{
						ResetTiming ();
						SetStatus ("Load failed", 1000);
					}
					mMain.display.setCurrent (mMain.mCanvas);
				}
			}.start ();
		}
		else if (c == cmdBack && d == formSave)
		{
			mMain.display.setCurrent (this);
		}
		else if (c == cmdBack && d == formLoad)
		{
			mMain.display.setCurrent (this);
		}
		else if (c == cmdRemove)
		{
			int iTrack = ((List)d).getSelectedIndex ();
			Levels levels = mMain.levels;

			if (d == lsEasy)
			{
				levels.leagues[0].RemoveLevel (iTrack);
			}
			else if (d == lsMedium)
			{
				levels.leagues[1].RemoveLevel (iTrack);
			}
			else if (d == lsPro)
			{
				levels.leagues[2].RemoveLevel (iTrack);
			}
			UpdateList ();
			if (((List)d).size() > 0)
				((List)d).setSelectedIndex (iTrack, true);

			SetStatus ("Level removed", 1000);
		}
		else if (c == cmdCreateNew)
		{
			int iTrack = ((List)d).getSelectedIndex ();
			Levels levels = mMain.levels;

			Level newLevel = new Level ();
			newLevel.Name = "New level";
			newLevel.x0 = -70;
			newLevel.y0 = 20 - 110;
			newLevel.xEnd = 70;
			newLevel.yEnd = 0 - 110;
			
			for (int x = -100; x < 100; x += 30)
			{
				Point2 pt = new Point2 ();
				pt.x = x;
				pt.y = 0 - 110;
				newLevel.AddPoint (pt);
			}

			if (d == lsEasy)
			{
				levels.leagues[0].InsertLevel (iTrack, newLevel);
			}
			else if (d == lsMedium)
			{
				levels.leagues[1].InsertLevel (iTrack, newLevel);
			}
			else if (d == lsPro)
			{
				levels.leagues[2].InsertLevel (iTrack, newLevel);
			}
			UpdateList ();
			((List)d).setSelectedIndex (iTrack, true);

			SetStatus ("Level created", 1000);
		}
		else if (c == cmdRun)
		{
			mMain.RunGame ();
		}
	}


	long lastTime = System.currentTimeMillis ();

	long lTimeInMove = 0;

	boolean bCanLeft = true;
	boolean bCanRight = true;
	boolean bCanUp = true;
	boolean bCanDown = true;

	void ResetTiming ()
	{
		lastTime = System.currentTimeMillis ();
	}

	public void paint(Graphics g)
	{
		long currTime = System.currentTimeMillis ();
		int dTime = (int)(currTime - lastTime);
		lastTime = currTime;

		if (iStatusTimeout != INFINITY)
			iStatusTimeout -= dTime;
		if (iStatusTimeout <= 0)
			sStatus = "";

		int dMove = ((dTime)*(nSpeed))/1000;
		if (dMove > 2)
			dMove = 2;

		boolean bMoving = false;

		if (keys[kUP] && bCanUp)
		{
			camY += dMove;
			bMoving = true;
		}
		if (keys[kDOWN] && bCanDown)
		{
			camY -= dMove;
			bMoving = true;
		}
		if (keys[kLEFT] && bCanLeft)
		{
			camX -= dMove;
			bMoving = true;
		}
		if (keys[kRIGHT] && bCanRight)
		{
			camX += dMove;
			bMoving = true;
		}

		if (bMoving)
			lTimeInMove += dTime;
		else
			lTimeInMove = 0;

		w = getWidth ();
		h = getHeight ();

		g.setColor (255, 255, 255);
		g.fillRect (0, 0, w, h);

		Level level = mMain.levels.leagues[curLevel].GetLevel (curTrack);
		if (level == null)
		{
			g.setColor (210, 210, 255);
			g.fillRect (0, 0, w, font.getHeight() + 2);
			g.setColor (0, 0, 55);
			g.drawLine (0, font.getHeight() + 2, w, font.getHeight() + 2);
			font.drawString (g, "No level", 1, 2);
			repaint ();
			return;
		}

		int baseY = camY + h/2;
		g.setColor (100, 100, 255);
		g.setStrokeStyle (g.DOTTED);
		g.drawLine (0, baseY, w, baseY);
		g.drawLine (w/2 - camX, baseY-8, w/2 - camX, baseY+8);

		g.setStrokeStyle (g.SOLID);


		{
			int dX = camX - level.x0;
			if (dX < 0)
				dX *= -1;
			int dY = camY - level.y0 - 110;
			if (dY < 0)
				dY *= -1;

			if (dX < 10 && dY < 10)
			{	
				if (!bMoving)
				{
					camX = level.x0;
					camY = level.y0 + 110;
				}
				else if (keys[kNUM7])
				{
					if (keys[kUP])
					{
						level.y0 += dMove;
					}
					if (keys[kDOWN])
					{
						level.y0 -= dMove;
					}
					if (keys[kLEFT])
					{
						level.x0 -= dMove;
					}
					if (keys[kRIGHT])
					{
						level.x0 += dMove;
					}
				}
			}
			g.setColor (0, 0, 255);
			g.drawLine (w/2 - camX + level.xEnd - 2, 0, w/2 - camX + level.xEnd - 2, h);
			g.drawLine (w/2 - camX + level.xEnd + 2, 0, w/2 - camX + level.xEnd + 2, h);

			dX = camX - level.xEnd;
			if (dX < 0)
				dX *= -1;
			if (dX <= 2)
			{
				if (keys[kNUM7])
				{
					if (keys[kLEFT])
					{
						level.xEnd -= dMove;
					}
					if (keys[kRIGHT])
					{
						level.xEnd += dMove;
					}
				}
			}
		}
	
		int nPointsInView = 0;
		boolean bSelected = false;
		for (int i = 0; i < level.Count(); i++)
		{
			Point2 pt = level.GetPoint(i);
			
			Point2 ptNext = null;
			int pXn = 0, pYn = 0;
			if (i < level.Count() - 1)
			{
				ptNext = level.GetPoint(i + 1);
				pXn = -camX + w/2 + ptNext.x;
				pYn = camY + h/2 - ptNext.y - 110;
			}

			Point2 ptPrev = null;
			if (i > 0)
				ptPrev = level.GetPoint(i - 1);
			
			int pX = -camX + w/2 + pt.x;
			int pY = camY + h/2 - pt.y - 110;

			if ((pX < 0 || pX > w || pY < 0 || pY > h))
				if ((i == level.Count() - 1) || (((pXn < 0 && pX < 0) || (pXn > w && pX > w) || pYn < 0 || pYn > h)))
					continue;

			nPointsInView++;

			if (bDrawVertexCoords)
				font.drawString (g, "(" + pt.x + "," + (pt.y+110 + 3) + ")", pX, pY);

			int dX = camX - pt.x;
			if (dX < 0)
				dX *= -1;
			int dY = camY - pt.y - 110;
			if (dY < 0)
				dY *= -1;

			if (dX <= 2 && dY <= 2 && !bSelected)
			{
				iCurVertex = i;
				bSelected = true;
				if (!bMoving)
				{
					camX = pt.x;
					camY = pt.y + 110;

					iCurVertex = i;
				}
				else if (keys[kNUM7])
				{
					if (keys[kUP])
					{
						pt.y += dMove;
					}
					if (keys[kDOWN])
					{
						pt.y -= dMove;
					}
					if (keys[kLEFT])
					{
						pt.x -= dMove;
					}
					if (keys[kRIGHT])
					{
						pt.x += dMove;
					}
					if (i != 0)
					{
						if (ptPrev != null)
						{
							if (pt.x - ptPrev.x > 127)
							{
								pt.x = ptPrev.x + 127;
								bCanRight = false;
							}
							else bCanRight = true;

							if (pt.x - ptPrev.x <= 4)
							{
								bCanLeft = false;
								pt.x = ptPrev.x + 4;
							}
							else bCanLeft = true;
	
							if (pt.y - ptPrev.y > 127)
							{
								pt.y = ptPrev.y + 127;
								bCanUp = false;
							}
							else bCanUp = true;

							if (pt.y - ptPrev.y < -127)
							{
								pt.y = ptPrev.y - 127;
								bCanDown = false;
							}
							else bCanDown = true;
						}
					}

					if (i != level.Count()-1)
					{
						if (ptNext != null)
						{
							if (pt.x - ptNext.x < -127)
							{
								pt.x = ptNext.x - 127;
								bCanLeft = false;
							}
							else bCanLeft = true;

							if (ptNext.x - pt.x <= 4)
							{
								pt.x = ptNext.x - 4;
								bCanRight = false;
							}
							else bCanRight = true;

							if (pt.y - ptNext.y > 127)
							{
								pt.y = ptNext.y + 127;
								bCanUp = false;
							}
							else bCanUp = true;

							if (pt.y - ptNext.y < -127)
							{
								pt.y = ptNext.y - 127;
								bCanDown = false;
							}
							else bCanDown = true;
						}
					}
					camX = pt.x;
					camY = pt.y + 110;
				}
			}

			g.setColor (0, 255, 0);
			if (i < level.Count() - 1)
			{
				if (pXn - pX > 127)
					g.setColor (255, 0, 0);

				g.drawLine (pX, pY, pXn, pYn);
			}

			g.setColor (0, 140, 0);
			g.fillRect (pX - 2, pY - 2, 4, 4);
		}

		g.setColor (0, 0, 0);
		g.drawArc (-camX + w/2 + level.x0 - 10, -110 + camY + h/2 - level.y0 - 10, 20, 20, 0, 360);

		g.setColor (0, 0, 0);
		g.drawLine (w/2, h/2, w/2 + 8, h/2 + 4);
		g.drawLine (w/2 + 8, h/2 + 4, w/2 + 4, h/2 + 8);
		g.drawLine (w/2 + 4, h/2 + 8, w/2, h/2);
		font.drawString (g, "(" + camX + "," + (camY) + ")", w/2 + 2, h/2 + 10);

		g.setColor (210, 210, 255);
		g.fillRect (0, 0, w, font.getHeight() + 2);
		g.setColor (0, 0, 55);
		g.drawLine (0, font.getHeight() + 2, w, font.getHeight() + 2);
		font.drawString (g, level.Name, 1, 2);

		g.setColor (210, 210, 255);
		g.fillRect (0, h - font.getHeight() - 2, w, font.getHeight() + 2);
		g.setColor (0, 0, 55);
		g.drawLine (0, h - font.getHeight() - 2, w, h - font.getHeight() - 2);
		font.drawString (g, sStatus, 1, h - font.getHeight());

		//serviceRepaints ();
		repaint ();
	}
}
