package gravity_edit;

import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import java.io.*;
import javax.microedition.io.*;
import java.util.*;

import gravity_edit.game.*;

public class Main extends MIDlet
{
	boolean bPaused = false;
	Display display;

	MyCanvas mCanvas;

	public FileSystem fs = new FileSystem ();

	public Levels levels;

	public Main() 
	{
		display = Display.getDisplay (this);

		levels = new Levels ();

		byte[] data = null; //fs.ReadJsr75 ("levels_test.mrg");
		if (data == null)
		{
			levels.Load ();
			System.out.println ("[Load] from jar");
		}
		else
		{
			levels.Load (data);
			System.out.println ("[Load] from file - jsr75");
		}

		//fs.WriteJsr75 ("levels_test.mrg", levels.Save ());

		mCanvas = new MyCanvas (this);
		display.setCurrent (mCanvas);
	}

	Thread gameThread = null;

	Main mdl = this;
	Micro game = null;

	class GameThread extends Thread
	{
		public void run()
		{
			try
			{
				game = new Micro ();
				game.mMain = mdl;
				game.mDisplay = display;
				game.data = levels.Save ();
				game.startApp ();
			}
			catch (Exception e)
			{
				System.out.println (e);
			}
		}
	};

	public void RunGame ()
	{
		gameThread = new GameThread();
		gameThread.start ();
	}

	public void StopGame ()
	{
		try
		{
			gameThread.join ();
			gameThread = null;
			game = null;
			System.gc ();
			display.setCurrent (mCanvas);
		}
		catch (Exception e)
		{
			System.out.println (e);
		}
	}

	public boolean isPaused() 
	{
		return bPaused;
	}

	public void startApp() 
	{
		bPaused = false;
	}


	public void pauseApp() 
	{
		bPaused = true;
	}

	public void destroyApp(boolean unconditional) 
	{
		notifyDestroyed();
	}
}

class Point2
{
	public int x, y;
}

class Level
{
	public String Name = "";
	public Vector pPoints;
	public int x0 = 0, y0 = 0;
	public int xEnd = 0, yEnd = 0;

	Level ()
	{
		pPoints = new Vector ();
	}

	Level (Level lv)
	{
		pPoints = new Vector ();
		Name = new String (lv.Name);
		x0 = lv.x0;
		y0 = lv.y0;
		xEnd = lv.xEnd;
		yEnd = lv.yEnd;
		for (int i = 0; i < lv.pPoints.size(); i++)
		{
			Point2 pt = new Point2 ();
			pt.x = ((Point2)lv.pPoints.elementAt(i)).x;
			pt.y = ((Point2)lv.pPoints.elementAt(i)).y;
			pPoints.addElement (pt);
		}
	}

	int Count ()
	{
		return pPoints.size ();
	}

	void AddPoint (Point2 pt)
	{
		pPoints.addElement (pt);
	}

	void InsertPoint (int iBefore, Point2 pt)
	{
		pPoints.insertElementAt (pt, iBefore);
	}

	void RemovePoint (int iPoint)
	{
		pPoints.removeElementAt (iPoint);
	}

	Point2 GetPoint (int iPoint)
	{
		return (Point2)pPoints.elementAt (iPoint);
	}
}

class League
{
	public Vector pLevels;

	League (int n)
	{
		pLevels = new Vector(n);
	}

	League ()
	{
		pLevels = new Vector ();
	}

	int Count ()
	{
		return pLevels.size ();
	}

	Level GetLevel (int iLevel)
	{
		if (iLevel >= 0 && pLevels.size() > iLevel)
			return (Level)pLevels.elementAt (iLevel);
		else
			return null;
	}

	void AddLevel (Level lvl)
	{
		pLevels.addElement (lvl);
	}

	void RemoveLevel (int iLevel)
	{
		pLevels.removeElementAt (iLevel);
	}

	void Swap (int i1, int i2)
	{
		Level lv1 = (Level)pLevels.elementAt (i1);
		Level lv2 = (Level)pLevels.elementAt (i2);
		pLevels.setElementAt (lv2, i1);
		pLevels.setElementAt (lv1, i2);
	}

	void InsertLevel (int iBefore, Level level)
	{
		pLevels.insertElementAt (level, iBefore);
	}

	void Clear ()
	{
		pLevels.removeAllElements ();
	}
}

class Levels
{
	League[] leagues = new League[3];

	void Load (byte[] data)
	{
		try
		{
			DataInputStream is = new DataInputStream (new ByteArrayInputStream (data));
			
			int[][] ptrs = new int[3][];

			int i;
			for (i = 0; i < 3; i++)
			{
				int nLvl = is.readInt ();
				leagues[i] = new League ();
				ptrs[i] = new int[nLvl];

				for (int j = 0; j < nLvl; j++)
				{
					ptrs[i][j] = is.readInt ();

					Level level = new Level ();

					char c;
					do
					{
						c = (char)is.readByte ();
						if(c != 0)
							level.Name += c;
					} while(c != 0);
					
					leagues[i].AddLevel (level);
				}
			}

			for (i = 0; i < 3; i++)
			{
				for (int j = 0; j < leagues[i].Count (); j++)
				{
					is.close ();
					is = new DataInputStream(new ByteArrayInputStream (data));

					is.skip (ptrs[i][j]);

					Level level = leagues[i].GetLevel (j);
					
					byte byte0 = is.readByte ();

					int temp;
					temp = is.readInt ();
					level.x0 = (temp >> 16) << 3;
					
					temp = is.readInt ();
					level.y0 = (temp >> 16) << 3;

					temp = is.readInt ();
					level.xEnd = (temp >> 16) << 3;

					temp = is.readInt ();
					level.yEnd = (temp >> 16) << 3;

					int nPoints = is.readShort ();

					int cX = is.readInt ();
					int cY = is.readInt ();
					Point2 pt = new Point2 ();
					pt.x = cX;
					pt.y = cY;
					level.AddPoint (pt);

					for (short k = 1; k < nPoints; k++)
					{
						Point2 p = new Point2 ();
						byte b1 = is.readByte ();
						int x, y;
						if (b1 == -1)
						{
							cX = 0;
							x = is.readInt ();
							y = is.readInt ();
						}
						else
						{
							x = b1;
							y = is.readByte ();
						}
						cX += x;
						cY += y;

						p.x = cX;
						p.y = cY;
						level.AddPoint (p);
					}
				}
			}
		}
		catch(IOException e)
		{
			System.out.println (e);
		}
	}
	void Load ()
	{
		byte[] data = null;
		try
		{
			DataInputStream is = new DataInputStream (getClass().getResourceAsStream("/levels.mrg"));
			int i = 0;
			int nSize = 0;
			do
			{
				if(i == -1)
					break;
				i = is.read();
				if(i != -1)
					nSize++;
			} while(true);

			data = new byte[nSize];
			is.close ();
			is = new DataInputStream (getClass().getResourceAsStream("/levels.mrg"));
			is.readFully (data);
			is.close ();
		}
		catch (Exception e)
		{
			System.out.println (e);
		}

		Load (data);
	}
	byte[] Save ()
	{
		ByteArrayOutputStream os = new ByteArrayOutputStream ();
		DataOutputStream out = new DataOutputStream (os);

		byte[] data = null;

		try
		{
			int pptrs[][] = new int[3][];
			int ptrs[][] = new int[3][];
			
			int pos = 0;
			for (int i = 0; i < 3; i++)
			{
				pptrs[i] = new int[leagues[i].Count()];
				ptrs[i] = new int[leagues[i].Count()];

				out.writeInt (leagues[i].Count());
				pos += 4;

				for (int j = 0; j < leagues[i].Count(); j++)
				{
					pptrs[i][j] = pos;
					out.writeInt (0);
					pos += 4;

					for (int k = 0; k < leagues[i].GetLevel(j).Name.length (); k++)
					{
						out.writeByte (leagues[i].GetLevel(j).Name.charAt(k));
						pos += 1;
					}
					out.writeByte (0);
					pos += 1;
				}
			}
			
			for (int i = 0; i < 3; i++)
			{
				for (int j = 0; j < leagues[i].Count(); j++)
				{
					Level level = leagues[i].GetLevel (j);
					ptrs[i][j] = pos;

					out.writeByte (0x33);
					pos += 1;

					out.writeInt ((level.x0 << 16) >> 3);
					pos += 4;
					out.writeInt ((level.y0 << 16) >> 3);
					pos += 4;
					out.writeInt ((level.xEnd << 16) >> 3);
					pos += 4;
					out.writeInt ((level.yEnd << 16) >> 3);

					pos += 4;

					out.writeShort ((short)level.Count ());
					pos += 2;

					Point2 pt0 = level.GetPoint (0);
					out.writeInt (pt0.x);
					out.writeInt (pt0.y);
					pos += 8;

					for (int k = 1; k < level.Count(); k++)
					{
						Point2 pt = level.GetPoint (k);

						out.writeByte (pt.x - pt0.x);
						out.writeByte (pt.y - pt0.y);
						pos += 2;

						pt0 = pt;
					}
				}
			}
			data = os.toByteArray ();

			for (int i = 0; i < 3; i++)
			{
				for (int j = 0; j < leagues[i].Count(); j++)
				{
					data[pptrs[i][j] + 0] = (byte)(ptrs[i][j] >> 24 & 0xff);
					data[pptrs[i][j] + 1] = (byte)(ptrs[i][j] >> 16 & 0xff);
					data[pptrs[i][j] + 2] = (byte)(ptrs[i][j] >> 8 & 0xff);
					data[pptrs[i][j] + 3] = (byte)(ptrs[i][j] >> 0 & 0xff);
				}
			}
		}
		catch (Exception e)
		{
			System.out.println (e);
		}

		return data;
	}
}


