package gravity_edit;

import javax.microedition.rms.*;
import javax.microedition.io.*;
import java.io.*;

import javax.microedition.io.file.*;

public class FileSystem
{
	public String rootJsr75 = "root1";
	public String rootSiemens = "0:\\";
	public String rootSymbian = "e:\\";

	FileSystem ()
	{
	}

	byte[] ReadRms (String fName)
	{
		byte[] data = null;

		try
		{
			RecordStore store = RecordStore.openRecordStore (fName, false);
			data = store.getRecord (1);
			if (data == null)
				return null;
		}
		catch(RecordStoreNotFoundException e)
		{
			System.out.println (e);
			return null;
		}
		catch (Exception ex)
		{
			System.out.println (ex);
			return null;
		}

		return data;
	}

	byte[] ReadSiemens (String fName)
	{
		SiemensFile file = new SiemensFile ();
		return file.Read (rootSiemens + fName);
	}

	byte[] ReadJsr75 (String fName)
	{
		byte[] data = null;

		try 
		{
			FileConnection fconn = (FileConnection)Connector.open("file:///" + rootJsr75 + "/" + fName);

			if (!fconn.exists())
				return null;

			DataInputStream is = fconn.openDataInputStream ();
			data = new byte[(int)fconn.fileSize ()];
			is.readFully (data);

			is.close ();
			fconn.close();
		}
		catch (IOException ioe) 
		{
			System.out.println (ioe);
			return null;
		}

		return data;
	}

	byte[] ReadSymbian (String fName)
	{
		byte[] data = null;
		String url = "socket://127.0.0.1:8100";

		try
		{
			StreamConnection conn = (StreamConnection)Connector.open(url);
			OutputStream out = conn.openOutputStream();

			char iMode = 0x01;
			String strFile = iMode + rootSymbian + fName + "\0";
			byte[] buffer = strFile.getBytes();
			out.write(buffer, 0, buffer.length);
			out.flush();
            
			InputStream ins = conn.openInputStream();
			DataInputStream in = new DataInputStream (ins);

			int length = in.readInt ();
			System.out.println (length);

			byte[] buf = new byte[length];
			in.readFully (buf);

			in.close();
			out.close();
			conn.close();

			data = buf;
		}
		catch(IOException ioe)
		{
			ioe.printStackTrace();
			return null;
		}

		return data;
	}

	boolean WriteRms (String fName, byte[] data)
	{
		if (data == null)
			return false;

		try
		{
			RecordStore store = RecordStore.openRecordStore (fName, true);
			if (store.getNumRecords () > 0)
				store.setRecord (1, data, 0, data.length);
			else
				store.addRecord (data, 0, data.length);
		}
		catch(RecordStoreNotFoundException e)
		{
			System.out.println (e);
			return false;
		}
		catch (Exception ex)
		{
			System.out.println (ex);
			return false;
		}

		return true;
	}

	boolean WriteSiemens (String fName, byte[] data)
	{
		SiemensFile file = new SiemensFile ();
		return file.Write (rootSiemens + fName, data);
	}

	boolean WriteJsr75 (String fName, byte[] data)
	{
		try 
		{
			FileConnection fconn = (FileConnection)Connector.open("file:///" + rootJsr75 + "/" + fName);

			if (!fconn.exists())
				fconn.create();

			DataOutputStream os = fconn.openDataOutputStream ();

			os.write (data, 0, data.length);

			os.close ();
			fconn.close();
		}
		catch (IOException ioe) 
		{
			System.out.println (ioe);
			return false;
		}

		return true;
	}

	boolean WriteSymbian (String fName, byte[] data)
	{
		byte iRes = -1;
		try
		{
			StreamConnection conn = (StreamConnection)Connector.open("socket://127.0.0.1:8100");
			OutputStream out = conn.openOutputStream();

			String sFile = rootSymbian + fName + '\0';

			int nSize = data.length;

			byte iMode = 0x02;
			byte[] buffer = new byte[1 + 4 + 1 + sFile.length() + nSize];
			buffer[0] = iMode;
			
			buffer[1] = (byte)(nSize & 0xff);
			buffer[2] = (byte)((nSize >> 8) & 0xff);
			buffer[3] = (byte)((nSize >> 16) & 0xff);
			buffer[4] = (byte)((nSize >> 24) & 0xff);

			buffer[5] = (byte)(sFile.length());

			System.arraycopy (sFile.getBytes(), 0, buffer, 6, sFile.length());

			System.arraycopy (data, 0, buffer, 6 + sFile.length (), nSize);

			out.write(buffer, 0, 1 + 4 + 1 + sFile.length() + nSize);
			out.flush();
			out.close();
        
			InputStream ins = conn.openInputStream();
			DataInputStream in = new DataInputStream (ins);

			iRes = in.readByte ();
            
			in.close();
			conn.close();

		}
		catch(IOException ioe)
		{
			ioe.printStackTrace();
			System.out.println (ioe);
			return false;
		}

		if (iRes != 0)
			return false;

		return true;
	}
}